 /**
* \file: FeatureDiscovery.h
*
* \version: 0.1
*
* \release: $Name:$
*
* Includes the interfaces to use the functionality of the Feature Discovery.
*
* \component: Unified SPI
*
* \author: D. Girnus / ADIT/SW2 / dgirnus@de.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef USPI_FEATURE_DISCOVERY_H_
#define USPI_FEATURE_DISCOVERY_H_


#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string>

#include <memory>

#include <iostream>

#include "FeatureDiscoveryTypes.h"
#include "IFeatureDiscovery.h"


namespace adit { namespace uspi {


class FeatureDiscoveryImpl;

/**
 * This class is the interface to start and stop the
 * FeatureDiscovery as well as the device detection.
 *
 */
class FeatureDiscovery
{
public:
    FeatureDiscovery(IFeatureDiscoveryCb* inCallbacks, uint32_t inEventMask);
    virtual ~FeatureDiscovery();

    /**
     * \brief Starts the FeatureDiscovery and device detection that uses
     *        the USPI DeviceDetector.
     *
     * \return 0 indicates success. A value < 0 indicates failure
     */
    DiscoveryError start(void);

    /**
     * \brief Stops the FeatureDiscovery and device detection.
     * \note  Blocking in one of the IFeatureDiscoveryCb API's
     *        blocks the return of the stop() call.
     *
     * \return 0 indicates success. A value < 0 indicates failure
     */
    DiscoveryError stop(void);


private:

    std::unique_ptr<FeatureDiscoveryImpl> mImpl;
};


} } /* namespace adit { namespace uspi { */


#endif /* USPI_FEATURE_DISCOVERY_H_ */
